/*
* Copyright (c) 1994-1998 Sun Microsystems, Inc. All Rights Reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for NON-COMMERCIAL or COMMERCIAL purposes and without fee is
* hereby granted. Please refer to the file
* http://java.sun.com/nav/business/trademark_guidelines.html for further
* important copyright and trademark information and to
* http://java.sun.com/nav/business/index.html for further important licensing
* information for the Java (tm) Technology.
* 
* SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
* SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
* IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
* NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
* LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
* ITS DERIVATIVES.
* 
* THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
* CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE PERFORMANCE,
* SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT NAVIGATION OR
* COMMUNICATION SYSTEMS, AIR TRAFFIC CONTROL, DIRECT LIFE SUPPORT MACHINES, OR
* WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE SOFTWARE COULD LEAD DIRECTLY TO
* DEATH, PERSONAL INJURY, OR SEVERE PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH
* RISK ACTIVITIES"). SUN SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED
* WARRANTY OF FITNESS FOR HIGH RISK ACTIVITIES.
*/

import java.applet.Applet;
import java.awt.*;
import java.util.*;
import java.net.*;
import java.lang.*;

/**
 * Glossary Applet by John Hoffmann: hoffie@eng.sun.com
 */

public class glossary extends Applet{
    static final int diagonal = 4;
    static final int diagonal_not = 0;
    static final int right_border = 16;
    static final int border = 6;
    static final int box_space = 4;
    static final int termArrow = 0;
    static final int defArrow = 1;
    static final int NO_USER_INPUT = 0;
    static final int NEW_SELECTION = 1;
    static final int SCROLLING_DEF = 2;
    static final int NOTHING_NEW = 0;
    static final int CHANGE_NEXT = 1;
    static final int CHANGE_CLEAR = 2;
    static final int REFRESH = 1;
    static final int ENABLE = 1;
    static final int DISABLE = 2;
    static final int TERM_INSET = 8;
    static final boolean CLEAR_NEEDED = true;
    static final boolean NO_CLEAR = false;
    static final boolean RAISED = true;
    static final boolean DEPRESSED = false;
    boolean clear_hit, tooLong, allLinesFit, bottom, tabs = false;
    boolean highlightDown[] = new boolean[2];
    boolean highlightUp[] = new boolean[2];
    boolean display_fields[];
    boolean search_fields[];
    boolean newDefaultSpace = false;
    Color bgColor = Color.white;
    Color bodyColor = new Color(255,204,153);
    Color termTextColor = new Color(102,51,0);
    Color defTextColor = new Color(102,51,0);
    Color defHyperlinkColor = new Color(0,0,255);
    Color bottomButtonTextColor = new Color(102,51,0);
    Color clearButtonTextColor = new Color(102,51,0);
    Color clearButtonDisabledTextColor = new Color(204,153,153);
    Color searchTextColor = new Color(102,51,0);
    Color searchFieldTextColor = new Color(102,51,0);
    Color bottomTextColor = new Color(102,51,0);
    Color bottomButtonColor = new Color(255,204,153);
    Color clearButtonColor = new Color(255,204,153);
    Color borderColor = new Color(102,51,0);
    Color arrowBorderColor = new Color(102,51,0);
    Color arrowActiveColor = new Color(255,51,0);
    Color arrowInactiveColor = new Color(153,0,0);
    Color termBgColor = new Color(204,204,255);
    Color termFgColor = new Color(153,153,255);
    Color tabColor[];
    Color tabTextColor[];
    Font microFont = new Font("Dialog", Font.PLAIN, 10);
    Font plainFont = new Font("Dialog", Font.PLAIN, 12);
    Font boldFont = new Font("Dialog", Font.BOLD, 12);
    Font regFont, smallFont;
    int maxParameters = 100;
    int maxIndecies = 10;
    int maxStrings = 10;
    int maxUrls = 10;
    int numTabs = 10;
    int lineNumber, wordLoop, widthTest, tabLoop, urlLoop, numUrls = 0;
    int strLength, stry, regHeight, regAscent, firstLine, lastLine, maxRows = 0;
    int box_top, currentTab, microHeight, ap_height, upy, totalStringWidth = 0;
    int bottom_display, rowTwoStartsAt, arrowx, extra, user_input, tabInt = 0;
    int def_box_width, def_box_height, loop, str_loop, left_edge, downy = 0;
    int totalStringWidthRow2, totalStringWidthRow1, rowLoop, numTabRows = 0;
    int tab_field, url_field, see_also_field, termInset, search_loop = 0;
    int index, terminc, numterms, done, currentItem, currentMatch = 0;
    int scrollArrowx, scrollDowny, scrollUpy, ap_width, box_width = 0;
    int search_field = REFRESH;
    int clear_button = CHANGE_CLEAR;
    int clear_button_state = DISABLE;
    int box_left[] = new int[2];
    int tabStrWidth[][];
    Image definitionImage, termImage, bigImage;
    Integer tabInteger;
    Graphics definitionBufG, termBufG, bigBufG;
    Polygon upperBody = new Polygon();
    Polygon lowerBody = new Polygon();
    Polygon upArrow[] = new Polygon[2];
    Polygon downArrow[] = new Polygon[2];
    Rectangle jumpButtonRect, clearButton, searchFieldRect;
    Rectangle clickTerms[] = new Rectangle[5];
    Rectangle urlRects[];
    Rectangle tabRects[];
    String tabStr[];
    String termDisplayStr[];
    String terms[][];
    String definitions[][];
    String definitionWords[];
    String clearButtonStr = new String("Clear");
    String currentSearchStr = new String("");
    String data_sep, newDefaultStr = new String("");
    String moreinfoLabelStr, searchLabelStr = new String("");
    String newDefault, newDefault2Str = new String("");
    String inputStr, nextWord, newStr, newLine, tempStr = new String("");
    URL externalURLs[];
    URL productURL;

    //Initialize: get parameters, create offscreen images, define rects
    public void init() {
	ap_height = size().height;
	ap_width = size().width;
    	box_width = ap_width-right_border-2*3-3;
	initGetParameters();
	initRectsAndRegions();
        bigImage = createImage(ap_width,ap_height);
        bigBufG = bigImage.getGraphics();
	bigBufG.setColor(bgColor);
	bigBufG.fillRect(0,0,ap_width,ap_height);
        termImage = createImage(box_width,100);
        termBufG = termImage.getGraphics();
	termBufG.setColor(bgColor);
	termBufG.fillRect(0,0,box_width,100);
        definitionImage = createImage(def_box_width-2*1-12,def_box_height-2*1);
        definitionBufG = definitionImage.getGraphics();
	setTermArrows();
	drawTermsOffScreen();
	drawDefinition();
	drawApplet();
    }

    public void initGetParameters() {
	int[] 	ints;
	int 	display_loop, src_inc, dis_inc = 0;
	Integer	tmpInteger;
	boolean	REMOVE_ME = false;
        String	term_data_format[] = new String[20];

	try {
	    if ( ( getParameter("use-default-colors").trim().startsWith("no") )
 		||  (getParameter("use-default-colors").trim().startsWith("false")) ){
		ints = parseInt(getParameter("background-color"), " ");
		bgColor = new Color(ints[0], ints[1], ints[2]);
		ints = parseInt(getParameter("body-color"), " ");
		bodyColor = new Color(ints[0], ints[1], ints[2]);
		ints = parseInt(getParameter("border-color"), " ");
		borderColor = new Color(ints[0], ints[1], ints[2]);
		ints = parseInt(getParameter("arrow-border-color"), " ");
		arrowBorderColor = new Color(ints[0], ints[1], ints[2]);
		ints = parseInt(getParameter("arrow-active-color"), " ");
		arrowActiveColor = new Color(ints[0], ints[1], ints[2]);
		ints = parseInt(getParameter("arrow-inactive-color"), " ");
		arrowInactiveColor = new Color(ints[0], ints[1], ints[2]);
		ints = parseInt(getParameter("term-background-color"), " ");
		termBgColor = new Color(ints[0], ints[1], ints[2]);
		ints = parseInt(getParameter("term-foreground-color"), " ");
		termFgColor = new Color(ints[0], ints[1], ints[2]);
		ints = parseInt(getParameter("term-selected-text-color"), " ");
		termTextColor = new Color(ints[0], ints[1], ints[2]);
		ints = parseInt(getParameter("search-text-color"), " ");
		searchTextColor = new Color(ints[0], ints[1], ints[2]);
		ints = parseInt(getParameter("search-field-text-color"), " ");
		searchFieldTextColor = new Color(ints[0], ints[1], ints[2]);
		ints = parseInt(getParameter("definition-text-color"), " ");
		defTextColor = new Color(ints[0], ints[1], ints[2]);
		ints = parseInt(getParameter("definition-hyperlink-color"), " ");
		defHyperlinkColor = new Color(ints[0], ints[1], ints[2]);
		ints = parseInt(getParameter("clear-button-color"), " ");
		clearButtonColor = new Color(ints[0], ints[1], ints[2]);
		ints = parseInt(getParameter("clear-button-text-color"), " ");
		clearButtonTextColor = new Color(ints[0], ints[1], ints[2]);
		ints = parseInt(getParameter("clear-button-disabled-text-color"), " ");
   		clearButtonDisabledTextColor = new Color(ints[0], ints[1], ints[2]);
	    }
	    tabInteger = new Integer(getParameter("number-of-terms").trim());
	    maxParameters = tabInteger.intValue();
    	    termDisplayStr = new String[maxParameters];
	    tabInteger = new Integer(getParameter("max-indecies").trim());
	    maxIndecies = tabInteger.intValue();
            terms = new String[maxParameters][maxIndecies];
	    tabInteger = new Integer(getParameter("max-strings").trim());
	    maxStrings = tabInteger.intValue();
            definitions = new String[maxParameters][maxStrings];
    	    display_fields = new boolean[maxIndecies];
    	    search_fields = new boolean[maxIndecies];
	    tabInteger = new Integer(getParameter("max-urls").trim());
	    maxUrls = tabInteger.intValue();
   	    urlRects = new Rectangle[maxUrls];
    	    externalURLs = new URL[maxUrls];
	    regFont = plainFont;
	    smallFont = plainFont;
	    if ( (getParameter("term-text-bold").trim().startsWith("yes"))
		|| (getParameter("term-text-bold").trim().startsWith("true")) ) {
		smallFont = boldFont;
	    }
	    if ( (getParameter("using-bottom-button").trim().startsWith("yes")) 
		|| (getParameter("using-bottom-button").trim().startsWith("true")) ) {
		bottom = true;
	    }
	    if ( ( getParameter("using-tabs").trim().startsWith("yes"))  
		|| (getParameter("using-tabs").trim().startsWith("true")) ) {
		tabs = true;
	    }
	    if ( (getParameter("term-match-default-plus-space").trim().startsWith("yes"))
		|| (getParameter("term-match-default-plus-space").trim().startsWith("true")) ) {
		newDefaultSpace = true;
	    }
	    data_sep = new String(getParameter("data-separator"));
     	    searchLabelStr = new String(getParameter("search-text"));
	    newDefault = new String(getParameter("term-match-default-string"));
	    term_data_format = parse(getParameter("term-data-format"), data_sep);
	} catch (Exception e) {
	    e.printStackTrace();
	}
	if (bottom) {
	    extra = border*4;
	    try {
	   	ints = parseInt(getParameter("bottom-button-color"), " ");
                bottomButtonColor = new Color(ints[0], ints[1], ints[2]);
    	        ints = parseInt(getParameter("bottom-button-text-color"), " ");
                bottomButtonTextColor = new Color(ints[0], ints[1], ints[2]);
    	        ints = parseInt(getParameter("bottom-text-color"), " ");
                bottomTextColor = new Color(ints[0], ints[1], ints[2]);
     	        moreinfoLabelStr = new String(getParameter("bottom-button-text"));
	        tmpInteger = new Integer(getParameter("bottom-text-from-term-field-number").trim());
		bottom_display = tmpInteger.intValue();
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	}
	termInset = 2;
	if (tabs) {
	    try {
	    	tabInteger = new Integer(getParameter("num-tabs").trim());
	    	numTabs = tabInteger.intValue();
    	    	tabColor = new Color[numTabs];
    	    	tabTextColor = new Color[numTabs];
    	    	tabRects = new Rectangle[numTabs];
    	   	tabStr = new String[numTabs];
    	        tabStrWidth = new int[2][numTabs];
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	    termInset = TERM_INSET;
	    done = 0;
	    //getting region strings and colors
	    loop = -1;
	    do {
	    	loop++;
	    	try {
 		    if (getParameter("tab-text-" + loop) == null) {
		    	done = 1;
		    }
		    else {
	 	    	tabStr[loop] = getParameter("tab-text-" + loop);
    	    	    	ints = parseInt(getParameter("tab-color-" + loop), " ");
            	    	tabColor[loop] = new Color(ints[0], ints[1], ints[2]);
		    	if (getParameter("tab-text-color-" + loop) != null) {
    	    	   	    ints = parseInt(getParameter("tab-text-color-" + loop), " ");
            	   	    tabTextColor[loop] = new Color(ints[0], ints[1], ints[2]);
			}
			else {
			    tabTextColor[loop] = new Color(102, 51, 0);
			}
		    }
	   	} catch (Exception e) {
		    e.printStackTrace();
	   	}
	    }
	    while (done == 0);
	    numTabs = loop;
	}
	//set variables based on term-data-format input
	for (loop=0; loop < term_data_format.length; loop++) {
	    search_fields[loop] = false;
	    display_fields[loop] = false;
	    if (term_data_format[loop].startsWith("tab")) {
		tab_field = loop;
	    }
	    else if (term_data_format[loop].startsWith("URL")) {
		url_field = loop;
	    }
	    else if (term_data_format[loop].startsWith("see")) {
		see_also_field = loop;
	    }
	    else if (term_data_format[loop].startsWith("dis")) {
		display_fields[loop] = true;
	    }
	    else if (term_data_format[loop].startsWith("search&d")) {
		search_fields[loop] = true;
		display_fields[loop] = true;
	    }
	    else if (term_data_format[loop].startsWith("search")) {
		search_fields[loop] = true;
	    }
	}

	//getting term/def values
	done = 0;
	loop = -1;
	do {
	    loop++;
	    try {
 		if (getParameter("t"+loop) == null) {
		    done = 1;
		}
		else {
	 	    terms[loop] = parse(getParameter("t"+loop), data_sep);
		    termDisplayStr[loop] = new String("");
		    for (str_loop = 0; str_loop < terms[loop].length; str_loop++) {
			if ( display_fields[str_loop] ) {
			    tempStr = new String(termDisplayStr[loop]+" "+terms[loop][str_loop]);
			    termDisplayStr[loop] = tempStr;
			}
		    }
	 	    definitions[loop] = parse(getParameter("d"+loop), data_sep);
		}
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	}
	while (done == 0);
	numterms = loop;
    }

    public void initRectsAndRegions() {
	int totalTopWidth, insetWidth, clearButtonWidth, searchFieldWidth;

	microHeight = Toolkit.getDefaultToolkit().getFontMetrics(microFont).getHeight()+3;
	regHeight = Toolkit.getDefaultToolkit().getFontMetrics(regFont).getHeight()+3;
	regAscent = Toolkit.getDefaultToolkit().getFontMetrics(regFont).getAscent();

	clearButtonWidth = Toolkit.getDefaultToolkit().getFontMetrics(regFont).stringWidth("Clear")+4*2;
	searchFieldWidth = 80;
	totalTopWidth = Toolkit.getDefaultToolkit().getFontMetrics(regFont).stringWidth(searchLabelStr)+clearButtonWidth+searchFieldWidth+2*border;
	insetWidth = ((ap_width-1-right_border)-totalTopWidth)/2;
	clearButton = new Rectangle(ap_width-1-right_border-insetWidth-clearButtonWidth,border,clearButtonWidth,regHeight+3*2);
	searchFieldRect = new Rectangle(clearButton.x-border-searchFieldWidth,border,searchFieldWidth,regHeight+3*2);
	clear_button = CHANGE_CLEAR;
	box_top = clearButton.y+clearButton.height+microHeight+5+border;
	if (tabs) {
	    //calculating width of all tab strings
	    for (loop = 0; loop < numTabs; loop++) {
		tabStrWidth[0][loop] = Toolkit.getDefaultToolkit().getFontMetrics(microFont).stringWidth(tabStr[loop])-2;
		totalStringWidth += tabStrWidth[0][loop];
	    }
	    //calculating tab rects
	    box_left[0] = ((ap_width-1-17)-(totalStringWidth+numTabs*(box_space*3)))/2;
	    numTabRows = 1;
	    rowTwoStartsAt = 0;
	    if (box_left[0] < 10)
	    {
		rowTwoStartsAt = numTabs/2;
		numTabRows = 2;
		//re-calculating width of all tab strings in row 1
		for (loop = 0; loop < rowTwoStartsAt; loop++) {
			tabStrWidth[0][loop] = Toolkit.getDefaultToolkit().getFontMetrics(microFont).stringWidth(tabStr[loop])-2;
			totalStringWidthRow1 += tabStrWidth[0][loop];
		}
		box_left[0] = ((ap_width-1-17)-(totalStringWidthRow1+(rowTwoStartsAt-1)*(box_space*3)))/2;
		//re-calculating width of all tab strings in row 2
		for (loop = rowTwoStartsAt; loop < numTabs; loop++) {
			tabStrWidth[1][loop] = Toolkit.getDefaultToolkit().getFontMetrics(microFont).stringWidth(tabStr[loop])-2;
			totalStringWidthRow2 += tabStrWidth[1][loop];
		}
		box_left[1] = ((ap_width-1-17)-(totalStringWidthRow2+(numTabs-rowTwoStartsAt)*(box_space*3)))/2;
	    }
	    //adjust slector height based on need for a second row of tabs
	    if (numTabRows != 1) {
	        box_top += 4+microHeight+2*box_space;
	    }
	}
	else {
	    box_top -= 4+microHeight;
	}
   	upy = box_top+15;
    	downy = box_top+100-15;
    	def_box_width = ap_width-border*2-right_border-1;
    	def_box_height = ap_height-(box_top+100+border*2+extra+2);
    	arrowx = ap_width-15;
	upArrow[termArrow] = new Polygon();
	upArrow[termArrow].addPoint(arrowx, upy);
	upArrow[termArrow].addPoint(arrowx+6, upy-12);
	upArrow[termArrow].addPoint(arrowx+12, upy);
	upArrow[termArrow].addPoint(arrowx+6, upy+6);	
	upArrow[termArrow].addPoint(arrowx, upy);
	downArrow[termArrow] = new Polygon();
	downArrow[termArrow].addPoint(arrowx, downy);
	downArrow[termArrow].addPoint(arrowx+6, downy+12);
	downArrow[termArrow].addPoint(arrowx+12, downy);
	downArrow[termArrow].addPoint(arrowx+6, downy-6);
	downArrow[termArrow].addPoint(arrowx, downy);
	for (loop = 0; loop < 5; loop++) {
		clickTerms[loop] = new Rectangle(5,box_top+1+20*loop,box_width,19);
	}
	scrollArrowx = ap_width-35;
	scrollUpy = box_top+101+border+15;
	scrollDowny = ap_height-border-extra-15;
	upArrow[defArrow] = new Polygon();
	upArrow[defArrow].addPoint(scrollArrowx, scrollUpy);
	upArrow[defArrow].addPoint(scrollArrowx+4, scrollUpy-8);
	upArrow[defArrow].addPoint(scrollArrowx+8, scrollUpy);
	upArrow[defArrow].addPoint(scrollArrowx+4, scrollUpy+4);	
	upArrow[defArrow].addPoint(scrollArrowx, scrollUpy);
	downArrow[defArrow] = new Polygon();
	downArrow[defArrow].addPoint(scrollArrowx, scrollDowny);
	downArrow[defArrow].addPoint(scrollArrowx+4, scrollDowny+8);
	downArrow[defArrow].addPoint(scrollArrowx+8, scrollDowny);
	downArrow[defArrow].addPoint(scrollArrowx+4, scrollDowny-4);
	downArrow[defArrow].addPoint(scrollArrowx, scrollDowny);
	maxRows = (def_box_height-2*9)/(regHeight+2);
	
	if (tabs) {
	    //defining the rectangels around the tabs
	    rowLoop = 0;

	    for (loop = 0; loop < numTabs; loop++) {
	        if ( (rowTwoStartsAt != 0) && (loop >= rowTwoStartsAt) ) {
		    rowLoop = 1;
	        }
	        if (rowTwoStartsAt != 0) {
	            tabRects[loop] = new Rectangle(box_left[rowLoop],box_top-(microHeight+4)*(2-rowLoop)-3,tabStrWidth[rowLoop][loop]+box_space*2,microHeight+2);
	        }
	        else {
	  	    tabRects[loop] = new Rectangle(box_left[rowLoop],box_top-microHeight-5,tabStrWidth[rowLoop][loop]+box_space*2,microHeight+2);
	        }
	        box_left[rowLoop] += tabStrWidth[rowLoop][loop]+box_space*3;
	    }
	}
	upperBody.addPoint(diagonal_not, 0);
	upperBody.addPoint(ap_width-1-right_border-diagonal_not, 0);
	upperBody.addPoint(ap_width-1-right_border, diagonal);
	upperBody.addPoint(ap_width-1-right_border, box_top-1-diagonal);
	upperBody.addPoint(ap_width-1-right_border-diagonal, box_top-1);
	upperBody.addPoint(diagonal, box_top-1);
	upperBody.addPoint(0, box_top-1-diagonal);
	upperBody.addPoint(0, diagonal_not);
	upperBody.addPoint(diagonal_not, 0);
	lowerBody.addPoint(diagonal, box_top+101);
	lowerBody.addPoint(ap_width-1-right_border-diagonal, box_top+101);
	lowerBody.addPoint(ap_width-1-right_border, box_top+101+diagonal);
	lowerBody.addPoint(ap_width-1-right_border, ap_height-1-diagonal_not);
	lowerBody.addPoint(ap_width-1-right_border-diagonal_not, ap_height-1);
	lowerBody.addPoint((ap_width-1-right_border)/2, ap_height-1);
	lowerBody.addPoint((ap_width-1-right_border)/2, ap_height-1-border-extra);
	lowerBody.addPoint(ap_width-1-right_border-border, ap_height-1-border-extra);
	lowerBody.addPoint(ap_width-1-right_border-border, box_top+101+border);
	lowerBody.addPoint(border, box_top+101+border);
	lowerBody.addPoint(border, ap_height-1-border-extra);
	lowerBody.addPoint((ap_width-1-right_border)/2, ap_height-1-border-extra);
	lowerBody.addPoint((ap_width-1-right_border)/2, ap_height-1);
	lowerBody.addPoint(diagonal_not, ap_height-1);
	lowerBody.addPoint(0, ap_height-1-diagonal_not);
	lowerBody.addPoint(0, box_top+101+diagonal);
	lowerBody.addPoint(diagonal, box_top+101);
	if (bottom) {
	    jumpButtonRect = new Rectangle(border, ap_height-regHeight-2-border, Toolkit.getDefaultToolkit().getFontMetrics(regFont).stringWidth(moreinfoLabelStr)+8, regHeight+2+2);
	}
    }

    public void drawTermsOffScreen() {
	termBufG.setFont(smallFont);
	terminc = -2;
	index = 0;
	do {
	    index = currentItem+terminc;
	    termBufG.setColor(termFgColor);
	    termBufG.fillRect(0,(terminc+2)*20,box_width,19);
	    if ((index >= 0) && ( index < numterms)) {
		if (tabs) {
		    tabInteger = new Integer(terms[index][tab_field].trim());
		    tabInt = tabInteger.intValue();
		    termBufG.setColor(tabColor[tabInt]);
		    termBufG.fillRect(0+1,(terminc+2)*20+1,termInset,19-2);//colored square at left of term
		    if ( terminc != 0 ) {
		    	termBufG.setColor(termBgColor);
		    }
		    else {
		    	termBufG.setColor(tabColor[tabInt]);
		    	termBufG.fillRect(0+1,(terminc+2)*20+1,box_width-2,19-2);
		    	termBufG.setColor(tabTextColor[tabInt]);
		    }
		}
		else {
	   	    if (terminc == 0) {
			termBufG.setColor(termBgColor);
	    	    	termBufG.fillRect(0,(terminc+2)*20,box_width,19);
		    	termBufG.setColor(termTextColor);
		    }
		    else {
			termBufG.setColor(termBgColor);
		    }
		}
		if ( (Toolkit.getDefaultToolkit().getFontMetrics(smallFont).stringWidth(termDisplayStr[index])) < (box_width-termInset)) {
		    termBufG.drawString(termDisplayStr[index], termInset+2, 14+(terminc+2)*20);
		}
		else {
		    termBufG.setFont(microFont);
		    termBufG.drawString(termDisplayStr[index], termInset+2, 14-1+(terminc+2)*20);
		    termBufG.setFont(smallFont);
		}			
	    }
	    terminc++;
	}
	while (terminc < 3);
    }

    public void drawTabs(int tab_num, boolean tab_state) {
	bigBufG.setColor(tabColor[tab_num]);
	bigBufG.draw3DRect(tabRects[tab_num].x-1,tabRects[tab_num].y-1,tabRects[tab_num].width+1,tabRects[tab_num].height+1,tab_state);
	bigBufG.draw3DRect(tabRects[tab_num].x,tabRects[tab_num].y,tabRects[tab_num].width-1,tabRects[tab_num].height-1,tab_state);
	bigBufG.setColor(tabColor[tab_num]);
	bigBufG.fillRect(tabRects[tab_num].x+1,tabRects[tab_num].y+1,tabRects[tab_num].width-2,tabRects[tab_num].height-2);
	bigBufG.setFont(microFont);
	bigBufG.setColor(tabTextColor[tab_num]);
	bigBufG.drawString(tabStr[tab_num],tabRects[tab_num].x+box_space/2,tabRects[tab_num].y+microHeight-3);
    }

    public void drawApplet() {
	//clear the whole background
	bigBufG.setColor(bgColor);
	bigBufG.fillRect(0,0,ap_width,ap_height);
	//applet body
	bigBufG.setColor(bodyColor);
	bigBufG.fillPolygon(upperBody);
	bigBufG.fillPolygon(lowerBody);
	//applet border
	bigBufG.setColor(borderColor);
	bigBufG.drawPolygon(upperBody);
	bigBufG.drawPolygon(lowerBody);
	//erasing the seam in the polygon
	bigBufG.setColor(bodyColor);
	bigBufG.drawLine(lowerBody.xpoints[11], lowerBody.ypoints[11]+1, lowerBody.xpoints[12], lowerBody.ypoints[12]-1);
	if (tabs) {
	    //draw tab rects and strings
	    bigBufG.setFont(microFont);
	    for (loop = 0; loop < numTabs; loop++) {
		if (loop == currentTab) {
		    drawTabs(currentTab,DEPRESSED);
		}
		else {
		    drawTabs(loop,RAISED);
		}
	    }
	}
	//term selector and arrows
	updateArrows(termArrow);
	bigBufG.setColor(arrowBorderColor);
	//Up arrow cup
	bigBufG.drawLine(arrowx,upy+3,arrowx+6,upy+3+6);
	bigBufG.drawLine(arrowx+6,upy+3+6,arrowx+12,upy+3);
	//vertical line
	bigBufG.drawLine(arrowx+6,upy+3+6,arrowx+6,downy-3-6);
	//down arrow cup
	bigBufG.drawLine(arrowx,downy-3,arrowx+6,downy-3-6);
	bigBufG.drawLine(arrowx+6,downy-3-6,arrowx+12,downy-3);
	//horizontal line
	bigBufG.drawLine(4+box_width,box_top+50,arrowx+6,box_top+50);
	//drawing scroll up and down elements
	updateArrows(defArrow);
	bigBufG.setColor(arrowBorderColor);
	//drawing vertical line conecting def scroll arrows
	bigBufG.drawLine(scrollArrowx+4,scrollUpy+4,scrollArrowx+4,scrollDowny-4);
	//copy to termimage to this graphics context
	bigBufG.drawImage(termImage, 5, box_top+1, this);
	//copy over the offscreen image to the main graphics object
	bigBufG.drawImage(definitionImage, border+1, box_top+101+1+border, this);
	bigBufG.setColor(searchTextColor);
	//drawing label
	bigBufG.setFont(regFont);
	bigBufG.drawString(searchLabelStr,searchFieldRect.x-getFontMetrics(regFont).stringWidth(searchLabelStr)-border,border+regHeight);
	//drawing search field
	bigBufG.setColor(bodyColor);
	bigBufG.draw3DRect(searchFieldRect.x, searchFieldRect.y, searchFieldRect.width-1, searchFieldRect.height-1, false);
	bigBufG.fill3DRect(searchFieldRect.x+1, searchFieldRect.y+1, searchFieldRect.width-2, searchFieldRect.height-2, false);
	//drawing the clear/next button
	bigBufG.setColor(clearButtonColor);
	bigBufG.draw3DRect(clearButton.x, clearButton.y, clearButton.width-1, clearButton.height-1, true);
	bigBufG.fill3DRect(clearButton.x+1, clearButton.y+1, clearButton.width-2, clearButton.height-2, true);
	if (bottom) {
	    //drawing the product home page button
	    bigBufG.setColor(bottomButtonColor);
	    bigBufG.draw3DRect(jumpButtonRect.x, jumpButtonRect.y, jumpButtonRect.width-1, jumpButtonRect.height-1, true);
	    bigBufG.fill3DRect(jumpButtonRect.x+1, jumpButtonRect.y+1, jumpButtonRect.width-2, jumpButtonRect.height-2, true);
	    bigBufG.setColor(bottomButtonTextColor);
	    bigBufG.drawString(moreinfoLabelStr,jumpButtonRect.x+4,ap_height-border-4);
	    drawProductNameString(NO_CLEAR);
	}
    }

    public void drawProductNameString(boolean clearNeeded) {
	if (clearNeeded) {
	    bigBufG.setColor(bodyColor);
bigBufG.fillRect(jumpButtonRect.width+border+border,ap_height-border-2-regHeight,(ap_width-right_border-2)-(jumpButtonRect.x+jumpButtonRect.width+border+border),border+regHeight);
	}
	tempStr = new String(terms[currentItem][bottom_display].replace('-', ' '));
	if (tempStr.length()>32) {
	    tempStr = tempStr.substring(0,32) + "...";
	}
	bigBufG.setFont(regFont);
	bigBufG.setColor(bottomTextColor);
	bigBufG.drawString(tempStr,jumpButtonRect.width+border+border,ap_height-border-4);
    }

    public void updateArrows(int whichSet) {
	if (highlightUp[whichSet] == true) {
		bigBufG.setColor(arrowActiveColor);
	}
	else {
		bigBufG.setColor(arrowInactiveColor);
	}
	bigBufG.fillPolygon(upArrow[whichSet]);
	if (highlightDown[whichSet] == true) {
		bigBufG.setColor(arrowActiveColor);
	}
	else {
		bigBufG.setColor(arrowInactiveColor);
	}
	bigBufG.fillPolygon(downArrow[whichSet]);
	//border on def arrows
	bigBufG.setColor(arrowBorderColor);
	bigBufG.drawPolygon(upArrow[whichSet]);
	bigBufG.drawPolygon(downArrow[whichSet]);
    }

    public void setTermArrows() {
	highlightUp[termArrow] = true;
	highlightDown[termArrow] = true;
	if (currentItem == 0) {
	    highlightUp[termArrow] = false;
	}
	else if (currentItem == (numterms-1) ) {
	    highlightDown[termArrow] = false;
	}
    }

    public void paint(Graphics g) {
	if (user_input == NEW_SELECTION) {
	     //updating term box
	     drawTermsOffScreen();
	     //copy the termimage to the main offscreen image
	     bigBufG.drawImage(termImage, 5, box_top+1, this);
	     //update the definition box
	     drawDefinition();
	     //copy over the def offscreen image to the main offscreen image
	     bigBufG.drawImage(definitionImage, border+1, box_top+101+1+border, this);
	     if (tabs) {
		tabInteger =  new Integer(terms[currentItem][tab_field].trim());
	     	if (currentTab != tabInteger.intValue()) {
	            drawTabs(currentTab,RAISED);
	            drawTabs(tabInteger.intValue(),DEPRESSED);
		    currentTab = tabInteger.intValue();
	        }
	     }
	     updateArrows(termArrow);
	     if (bottom) {
		drawProductNameString(CLEAR_NEEDED);
	     }
	     user_input = NO_USER_INPUT;
	}
	else if (user_input == SCROLLING_DEF) {
	     //redraw a portion of definition
	     drawDefinition();
	     //copy over the def offscreen image to the main offscreen image
	     bigBufG.drawImage(definitionImage, border+1, box_top+101+1+border, this);
	     user_input = NO_USER_INPUT;
	}
	else if (!clear_hit) {
	     searchFieldUpdate(currentSearchStr);
	     if (clear_button_state == ENABLE) {
		    clearButtonUpdate("Enable"); 
	     }
	     else if (clear_button_state == DISABLE) {
		    clearButtonUpdate("Disable"); 
	     }
	}
	if (clear_button == CHANGE_NEXT) {
	     clearButtonUpdate("Next");
	} 
	else if (clear_button == CHANGE_CLEAR) {
	     clearButtonUpdate("Clear");
	}
	if (clear_button_state == ENABLE) {
	     clearButtonUpdate("Enable"); 
	}
	else if (clear_button_state == DISABLE) {
	     clearButtonUpdate("Disable"); 
	}
	if (search_field == REFRESH) {
	     searchFieldUpdate(currentSearchStr);
	}
	//copy over the main offscreen image to the visible image
	g.drawImage(bigImage, 0, 0, this);
	search_field = NOTHING_NEW;
	clear_button = NOTHING_NEW;
	clear_hit = false;
	requestFocus();
    }

    public void update(Graphics g) {
	paint(g);
    }

    public void drawDefinition() {
	//clearing out the definition box
	definitionBufG.setColor(bgColor);
	definitionBufG.fillRect(0,0,def_box_width-2*1-12,def_box_height-2*1);
	numUrls = 0;
	definitionBufG.setColor(defTextColor);
	definitionBufG.setFont(regFont);
	lineNumber = 0;
	loop = Math.abs(firstLine); //Determining with which string to start drawing
	left_edge = 0;
	index = currentItem;
	while (loop < definitions[index].length) {
	    //if we hit a URL
	    if ( (definitions[index][loop].toLowerCase().startsWith("mailt") ) ||
		( definitions[index][loop].toLowerCase().startsWith("ht") ) || 
		( definitions[index][loop].toLowerCase().startsWith("/") ) ) {
		//store this string as an email or web site address URL
		//handling the case of a relative URL
		if ( definitions[index][loop].toLowerCase().startsWith("/") ) {
		    try {
			externalURLs[numUrls] = new URL("http",getDocumentBase().getHost(),getDocumentBase().getPort(),definitions[index][loop].trim());
		    } catch (Exception e) {
		        e.printStackTrace();
		    }
		}
		else {
		    try {
			externalURLs[numUrls] = new URL(definitions[index][loop].trim());
		    } catch (Exception e) {
		        e.printStackTrace();
		    }
		}
		loop++;//knock off an extra increment
		//draw the next string in the definitions array
		lineNumber--;
		definitionBufG.setColor(defHyperlinkColor);
		strLength = definitionBufG.getFontMetrics(regFont).stringWidth(definitions[index][loop].trim());
		if ( (strLength+left_edge+border+5) > (def_box_width-border*2-5) ) {
		    lineNumber++;
		    left_edge = 0;
		}
		stry = 7+regAscent+lineNumber*regHeight;
		if (lineNumber <= maxRows) {
		    definitionBufG.drawString(definitions[index][loop].trim(), 5+left_edge, stry);
		    definitionBufG.drawLine(5+left_edge, stry, 5+left_edge+strLength, stry);
     		}
		urlRects[numUrls] = new Rectangle(border+5+left_edge, (2*7+stry+box_top+100)-regHeight, strLength, regHeight);
		definitionBufG.setColor(defTextColor);
		lineNumber++;
		numUrls++;
	    }
	    else {
		definitionWords = parse(definitions[index][loop], " ");
		wordLoop = 0;
	  	allLinesFit = true;
		while ( (wordLoop < definitionWords.length) && (allLinesFit) ) {
		     newLine = new String("");
		     tooLong = false;
		     while ( (!tooLong) && (wordLoop < definitionWords.length) ) {
			nextWord = new String(definitionWords[wordLoop]);
			if ( (definitionBufG.getFontMetrics(regFont).stringWidth(newLine+" "+nextWord)) > (def_box_width-border*2-5)) {
			    tooLong = true;
			}
			else {
			    tempStr = new String(newLine+" "+nextWord);
			    newLine = tempStr;
		            wordLoop++;
			}
		     }
		     if (lineNumber <= maxRows) {
		          definitionBufG.drawString(newLine.trim(), 5, 7+regAscent+lineNumber*regHeight);
		     }
		     else {
			  allLinesFit = false;
		     }
		     lineNumber++;
		     left_edge = definitionBufG.getFontMetrics(regFont).stringWidth(newLine)+3;
		}
	    }
	    loop++;
	 } //end of while loop for the number of strings in definition
	 //storing the number of lines in this definition
	 lastLine = lineNumber;
	 //update arrows
	 if (!allLinesFit) {
		highlightDown[defArrow] = true;
	 }
	 else {
		highlightDown[defArrow] = false;
	 }
	 if (firstLine < 0) {
		highlightUp[defArrow] = true;
	 }
	 else {
		highlightUp[defArrow] = false;
	 }
	 updateArrows(defArrow);
    }

    public void jumpToRegion(int tabClicked) {
	loop = 0;
	done = 0;
	while ( (done == 0) && (loop < numterms) ) {
	    tabInteger = new Integer(terms[loop][tab_field].trim());
	    if ( tabInteger.intValue() == tabClicked ) {
		currentItem = loop;
		setTermArrows();
		user_input = NEW_SELECTION;
		firstLine = 0;
		paint(getGraphics());
		done = 1;
	    }
	    loop++;
	}
    }

    public void searchFieldUpdate(String currentStr) {
	bigBufG.setColor(bgColor);
	bigBufG.fillRect(searchFieldRect.x+2, searchFieldRect.y+2, searchFieldRect.width-4, searchFieldRect.height-4);
	bigBufG.setColor(searchFieldTextColor);
	bigBufG.setFont(regFont);
	left_edge = searchFieldRect.x+4+2+bigBufG.getFontMetrics(regFont).stringWidth(currentStr);
	if (currentStr.length() > 0) {
	    if (left_edge < (searchFieldRect.x+searchFieldRect.width-5)) {
	    	bigBufG.drawString(currentStr, searchFieldRect.x+4, searchFieldRect.y+regHeight-2);
	    }
	    else {
		tempStr = currentStr;
		while (left_edge >= (searchFieldRect.x+searchFieldRect.width-5)) {
		    tempStr = tempStr.substring(1);
		    left_edge = searchFieldRect.x+4+2+bigBufG.getFontMetrics(regFont).stringWidth(tempStr);
		}
		bigBufG.drawString(tempStr, searchFieldRect.x+4, searchFieldRect.y+regHeight-2);
	    }
	}
	for (loop=-2; loop<3; loop++) {
	    bigBufG.drawLine(left_edge,searchFieldRect.y+searchFieldRect.height-8,left_edge+loop,searchFieldRect.y+searchFieldRect.height-8+4);
	}
    }

    public void clearButtonUpdate(String labelStr) {
	bigBufG.setColor(bodyColor);
	bigBufG.fillRect(clearButton.x+2, clearButton.y+2, clearButton.width-4, clearButton.height-4);
	if (labelStr.startsWith("E")) {
	    bigBufG.setColor(clearButtonTextColor);
	}
	else if (labelStr.startsWith("D")) {
	    bigBufG.setColor(clearButtonDisabledTextColor);
	}
	else {
	    clearButtonStr = labelStr;
	    bigBufG.setColor(clearButtonTextColor);
	}
	bigBufG.setFont(regFont);
	bigBufG.drawString(clearButtonStr,clearButton.x+4,clearButton.y+regHeight);
    }

    public void stringMatch(char keyHit) {
	//checking to see if we are resumming a search or starting a new one
	if (currentMatch != 0) {
	    terminc = currentMatch;
	    firstLine = 0;
	}
	//setting the string to be matched if we were called by keydown event, otherwise use old value of newStr
	if (keyHit != '\uffff') {
	    newStr = currentSearchStr;
	    newDefaultStr = newDefault + newStr;
	    if (newDefaultSpace) {
	   	 newDefault2Str = newDefault + " " + newStr;
	    }
	    terminc = 0;
	}
	done = 0;
	while ( (terminc < numterms) && (done == 0) ) {
	    loop = 0;
	    while ( (loop < terms[terminc].length) && (done == 0) ) {
		if (search_fields[loop]) {
		    if ( ( terms[terminc][loop].toLowerCase().startsWith(newStr))
		      || ( terms[terminc][loop].toLowerCase().startsWith(newDefaultStr)) 
		      || ( (newDefaultSpace) && (terms[terminc][loop].toLowerCase().startsWith(newDefault2Str))) ) {
		        done = 1;
		        currentItem = terminc;
		        currentMatch = terminc+1;
		        clear_button = CHANGE_NEXT;
		    }
		}
		loop++;
	    }
	    terminc++;
	}
	//making sure to reset currentMatch to zero if we looped through every string
	if (terminc == numterms) {
	    currentMatch = 0;
	    clear_button = CHANGE_CLEAR;
	}
	setTermArrows();
	user_input = NEW_SELECTION;
	paint(getGraphics());
    }

    public boolean keyDown(Event evt, int key) {
	if ( ( (Character.isLetterOrDigit((char)key)) || ((char)key == ' ') ) 
		&& ( key != Event.DOWN) && (key != Event.UP) && (key != 8) && (key != 127)
		 && ( key != Event.LEFT) && (key != Event.RIGHT) ) {
		newStr = currentSearchStr + String.valueOf((char)key).toLowerCase();
		currentSearchStr = newStr;
		search_field = REFRESH;
	 	clear_button_state = ENABLE;
		stringMatch((char)key);
	}
	else if ( (key == Event.DOWN) && (currentItem <= (numterms-2)) ) {
		currentItem++;
		setTermArrows();
		user_input = NEW_SELECTION;
		paint(getGraphics());
	}
	else if ( (key == Event.UP) && (currentItem >= 1) ) {
		currentItem--;
		setTermArrows();
		user_input = NEW_SELECTION;
		paint(getGraphics());
	}
	else if ( ( (key == 127) || (key == 8) ) && (currentSearchStr.length() > 0) ) {
	    if (currentSearchStr.length() > 1) {
		newStr = currentSearchStr.substring(0, currentSearchStr.length()-1);
		currentSearchStr = newStr;
		search_field = REFRESH;
	 	clear_button_state = ENABLE;
		stringMatch((char)key);
	    }
	    else {
		currentSearchStr = "";
		clear_button_state = DISABLE;
		clear_button = CHANGE_CLEAR;
		//clear_hit = true;
		paint(getGraphics());
	    }
	}
	return(true);
    }

    public boolean mouseDown(Event evt, int mouseX, int mouseY) {
        if ( upArrow[termArrow].inside(mouseX, mouseY) && (currentItem >= 1) ){
		currentItem--;
		setTermArrows();
		user_input = NEW_SELECTION;
		firstLine = 0;
		paint(getGraphics());
	}
	else if ( downArrow[termArrow].inside(mouseX, mouseY) && (currentItem <= (numterms-2)) ){
		currentItem++;
		setTermArrows();
		user_input = NEW_SELECTION;
		firstLine = 0;
		paint(getGraphics());
	}
	else if (clearButton.inside(mouseX, mouseY)) {
	    if (currentMatch == 0) {
		currentSearchStr = "";
		search_field = REFRESH;
	 	clear_button_state = DISABLE;
		clear_hit = true;
		paint(getGraphics());
	    }
	    else if (currentSearchStr != "") {
		//calling stringMatch with a char value that a user could not have typed to resume searching for NEXT
	 	stringMatch('\uffff');
	    }	
	}
	else if ( clickTerms[0].inside(mouseX, mouseY) && (currentItem >= 2) ){
		currentItem -= 2;
		setTermArrows();
		user_input = NEW_SELECTION;
		firstLine = 0;
		paint(getGraphics());
	}
	else if ( clickTerms[1].inside(mouseX, mouseY) && (currentItem >= 1) ){
		currentItem--;
		setTermArrows();
		user_input = NEW_SELECTION;
		firstLine = 0;
		paint(getGraphics());
	}
	else if ( clickTerms[3].inside(mouseX, mouseY) && (currentItem <= (numterms-2)) ){
		currentItem++;
		setTermArrows();
		user_input = NEW_SELECTION;
		firstLine = 0;
		paint(getGraphics());
	}
	else if ( clickTerms[4].inside(mouseX, mouseY) && (currentItem <= (numterms-3)) ){
		currentItem += 2;
		setTermArrows();
		user_input = NEW_SELECTION;
		firstLine = 0;
		paint(getGraphics());
	}
	else if ( downArrow[defArrow].inside(mouseX, mouseY) && (!allLinesFit) ){
		firstLine--;
		user_input = SCROLLING_DEF;
		paint(getGraphics());
	}
	else if ( upArrow[defArrow].inside(mouseX, mouseY) && (firstLine < 0) ){
		firstLine++;
		user_input = SCROLLING_DEF;
		paint(getGraphics());
	}
	else if ( (bottom) && (jumpButtonRect.inside(mouseX, mouseY)) ){
	    try {
	        if (terms[currentItem][url_field].trim().startsWith("ht")) {
		    productURL = new URL(terms[currentItem][url_field].trim());
	        }
	        else {
		    productURL = new URL("http",getDocumentBase().getHost(),getDocumentBase().getPort(),terms[currentItem][url_field].trim());
	        }
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	    getAppletContext().showDocument(productURL);
	}
	else if ( (mouseY > box_top+101+1+border) && (numUrls > 0) ){
		urlLoop = 0;
		while (urlLoop < numUrls) {
			if ( urlRects[urlLoop].inside(mouseX, mouseY) ){
				getAppletContext().showDocument(externalURLs[urlLoop]);
			}
			urlLoop++;
		}
	}
	else if (tabs) {
	    if ( (mouseY >= tabRects[0].y) && (mouseY <= tabRects[numTabs-1].y+tabRects[numTabs-1].height) ){
		tabLoop = 0;
		done = 0;
		while ( (tabLoop < numTabs) && ( done == 0) ) {
		    if ( tabRects[tabLoop].inside(mouseX, mouseY) ){
			jumpToRegion(tabLoop);
			done = 1;
		    }
		    tabLoop++;
		}
	    }
	}
	return(true);
    }

    // s is a string containing 'sep' separators.  This method
    // breaks up the string at the separators and returns the resulting
    // strings in an array.  The result may have zero length but is never null.

   String[] parse(String s, String sep)
   {
      StringTokenizer st = new StringTokenizer(s, sep);
      String result[] = new String[st.countTokens()];

      for (int i = 0; i < result.length; i++) {
          result[i] = st.nextToken();
      }
      return result;
   }

    // This method is similar to parse() except that the strings are 
    // assumed to be decimal integers.  This method coverts these integer
    // strings into integers and returns them in an array.
    // The result may have zero length but is never null.
    int[] parseInt(String s, String sep) {
	StringTokenizer st = new StringTokenizer(s, sep);
         int[] result = new int[st.countTokens()];

	for (int i=0; i<result.length; i++) {
            result[i] = Integer.parseInt(st.nextToken());
	}
        return result;
    }

    public String getAppletInfo() {
	return "Title: Glossary Applet\nAuthor: John Hoffmann, 1997-98 \nGlossary featuring text search";
    }
}

// System.out.println("loop:" + loop + " tabStr[loop]:" + tabStr[loop] + "\n");
